<?php
/*--------------------------------------------------------------------------------------------------
    CategorySearchAdapter.php 2020-05-27
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2019 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */


namespace GXModules\Gambio\StyleEdit\Adapters;


use CategoryListItemJsonSerializer;
use CategorySearchCondition;
use Gambio\StyleEdit\Core\Language\Entities\Language;
use GXModules\Gambio\StyleEdit\Adapters\Interfaces\CategorySearchAdapterInterface;
use LanguageCode;
use MainFactory;
use StaticGXCoreLoader;
use StringType;

class CategorySearchAdapter implements CategorySearchAdapterInterface
{
    /**
     * @var bool
     */
    protected $categoryListItemJsonSerializer;
    /**
     * @var object
     */
    protected $categoryReadService;
    /**
     * @var LanguageCode
     */
    protected $languageCode;


    public function __construct( Language $language)
    {
        $this->createLanguageCode($language);
        $this->createService();
        $this->createSerializer();
    }

    /**
     *
     */
    protected function createService(): void
    {
        $this->categoryReadService = StaticGXCoreLoader::getService('CategoryRead');
    }

    protected function createLanguageCode(Language $language): void
    {
        $this->languageCode = MainFactory::create(LanguageCode::class, new StringType($language->code()));
    }

    /**
     *
     */
    protected function createSerializer(): void
    {
        $this->categoryListItemJsonSerializer = MainFactory::create(CategoryListItemJsonSerializer::class);
    }

    public function searchByTerm(string $term)
    {
        $result = [];

        $searchCondition = CategorySearchCondition::createByArray([
            'search' => [
                'should' => [
                    [
                        'match' => [
                            'categories.categories_id' => $term
                        ]
                    ],
                    [
                        'like' => [
                            'categories_description.categories_name' => "%{$term}%"
                        ]
                    ]
                ]
            ]
        ]);

        $categories = $this->categoryReadService->searchCategories($this->languageCode, $searchCondition)->getArray();

        foreach ($categories as $category) {
            $data     = json_decode($this->categoryListItemJsonSerializer->serialize($category));
            $result[] = [
                'id'     => $data->id,
                'name'   => $data->name,
                'active' => $data->isActive
            ];
        }

        return $result;

    }
}